<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ForgetPasswordRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'email' => 'required|email|exists:users|max:255'
        ];
    }

    public function messages()
    {
        return [
            'email.email' => __('Invalid Email.'),
            'email.required' => __('Email field can\'t be empty.'),
            'email.exists' => __('Email not found.'),
        ];
    }
}
